/*
 * Decompiled with CFR 0.152.
 */
package moe.ytonidc.ytongame_hostingmenu;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import moe.ytonidc.ytongame_hostingmenu.Config;
import moe.ytonidc.ytongame_hostingmenu.client.HostingPackage;
import moe.ytonidc.ytongame_hostingmenu.client.RegionDetector;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import org.slf4j.Logger;

@Mod(value="ytongame_hostingmenu")
@Mod.EventBusSubscriber(modid="ytongame_hostingmenu", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Ytongame_hostingmenu {
    public static final String MODID = "ytongame_hostingmenu";
    public static final ResourceLocation hostingLogo = new ResourceLocation("ytongame_hostingmenu", "textures/gui/logo_ytongame.png");
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final Gson GSON = new Gson();

    public Ytongame_hostingmenu() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)Config.SPEC);
        HostingPackage.loadAsync();
    }

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            Minecraft mc = Minecraft.m_91087_();
            PackRepository packRepository = mc.m_91099_();
            File configFile = new File(mc.f_91069_, "config/modpack_info.json");
            if (!configFile.exists()) {
                LOGGER.debug("modpack_info.json not found, skipping auto setup");
                return;
            }
            String targetLang = "zh_cn";
            String currentLang = mc.m_91102_().m_264236_();
            if (!targetLang.equals(currentLang)) {
                LOGGER.info("Current language is '{}', switching to zh_cn", (Object)currentLang);
                mc.m_91102_().m_264110_(targetLang);
                mc.f_91066_.f_92075_ = targetLang;
                mc.f_91066_.m_92169_();
                LOGGER.info("Saving language '{}' to options", (Object)targetLang);
                RegionDetector.refreshLanguage(targetLang);
                mc.m_91391_();
            }
            ArrayList<String> languagePacks = new ArrayList<String>();
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(configFile), StandardCharsets.UTF_8);){
                boolean autoInstallEnabled;
                JsonObject json = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                JsonObject resourcePackInstall = json.getAsJsonObject("resource_pack_install");
                if (resourcePackInstall != null && resourcePackInstall.has("auto_install_enabled") && (autoInstallEnabled = resourcePackInstall.get("auto_install_enabled").getAsBoolean())) {
                    LOGGER.debug("Auto install already enabled by other means, skipping");
                    return;
                }
                JsonArray packsArray = json.getAsJsonArray("language_packs");
                if (packsArray != null) {
                    for (int i = 0; i < packsArray.size(); ++i) {
                        languagePacks.add(packsArray.get(i).getAsString());
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to read modpack_info.json", (Throwable)e);
                return;
            }
            if (languagePacks.isEmpty()) {
                return;
            }
            File resourcePacksDir = new File(mc.f_91069_, "resourcepacks");
            ArrayList<CallSite> packsToEnable = new ArrayList<CallSite>();
            for (String packName : languagePacks) {
                File packFile = new File(resourcePacksDir, packName);
                if (packFile.exists()) {
                    packsToEnable.add((CallSite)((Object)("file/" + packName)));
                    continue;
                }
                LOGGER.warn("Resource pack not found: {}", (Object)packName);
            }
            if (packsToEnable.isEmpty()) {
                return;
            }
            packRepository.m_10506_();
            ArrayList<String> selected = new ArrayList<String>(packRepository.m_10523_());
            boolean changed = false;
            for (String string : packsToEnable) {
                Pack pack = packRepository.m_10507_(string);
                if (pack == null || selected.contains(string)) continue;
                selected.add(string);
                changed = true;
                LOGGER.info("Auto-enabled resource pack: {}", (Object)string);
            }
            if (changed) {
                packRepository.m_10509_(selected);
                mc.m_91391_();
            }
        });
    }
}

